/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws.contact;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.juddi.datatype.Address;
import org.apache.juddi.datatype.AddressLine;

public class VWAddressEditDialog
extends VWModalDialog
implements ActionListener,
DocumentListener {
    public static final int STATUS_OK = 0;
    public static final int STATUS_CANCLE = 1;
    public static final int STATUS_HELP = 2;
    protected Frame m_parentFrame = null;
    protected JTextArea m_addressTextArea = new JTextArea();
    protected JTextField m_useTypeTextField = null;
    protected JButton m_okButton = new JButton(VWResource.s_ok);
    protected JButton m_cancelButton = new JButton(VWResource.s_cancel);
    protected JButton m_helpButton = new JButton(VWResource.s_help);
    protected int m_returnStatus = 0;
    private Address m_address = null;
    private boolean m_bChanged = false;

    public VWAddressEditDialog(Frame parent, Address address) {
        super(parent);
        this.setTitle(VWResource.s_edit);
        Dimension dim = VWStringUtils.stringToDimension("445,275");
        if (dim == null) {
            dim = new Dimension(400, 250);
        }
        this.setSize(dim.width, dim.height);
        this.setVisible(false);
        this.m_address = address;
        this.m_parentFrame = parent;
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.createMainPanel(), "Center");
        this.getContentPane().add((Component)this.createButtonPanel(), "Last");
        this.setLocationRelativeTo(parent);
    }

    public void releaseResources() {
        if (this.m_addressTextArea != null) {
            this.m_addressTextArea.removeAll();
            this.m_addressTextArea = null;
        }
        if (this.m_useTypeTextField != null) {
            this.m_useTypeTextField.removeAll();
            this.m_useTypeTextField = null;
        }
        if (this.m_okButton != null) {
            this.m_okButton.removeActionListener(this);
            this.m_okButton.removeAll();
            this.m_okButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this);
            this.m_cancelButton.removeAll();
            this.m_cancelButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton.removeAll();
            this.m_helpButton = null;
        }
        this.removeAll();
    }

    protected JPanel createMainPanel() {
        JPanel mainPanel = null;
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new BorderLayout(4, 4));
            mainPanel.add((Component)this.createAddressPanel(), "Center");
            mainPanel.add((Component)this.createTypePanel(), "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    protected JPanel createAddressPanel() {
        JPanel mainPanel = null;
        try {
            Vector addressLineVector;
            mainPanel = new JPanel();
            mainPanel.setLayout(new BorderLayout(4, 4));
            mainPanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_address)), "First");
            String addressText = "";
            if (this.m_address != null && (addressLineVector = this.m_address.getAddressLineVector()) != null) {
                int sz = addressLineVector.size();
                for (int i = 0; i < sz; ++i) {
                    if (addressLineVector.elementAt(i) == null || !(addressLineVector.elementAt(i) instanceof AddressLine)) continue;
                    addressText = addressText + ((AddressLine)addressLineVector.elementAt(i)).getLineValue() + "\n";
                }
            }
            this.m_addressTextArea = new JTextArea(addressText);
            this.m_addressTextArea.setLineWrap(true);
            this.m_addressTextArea.setWrapStyleWord(true);
            this.m_addressTextArea.getDocument().addDocumentListener(this);
            mainPanel.add((Component)new JScrollPane(this.m_addressTextArea), "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    protected JPanel createTypePanel() {
        JPanel mainPanel = null;
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new BorderLayout(4, 4));
            mainPanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_type)), "Before");
            this.m_useTypeTextField = new JTextField(this.m_address.getUseType());
            this.m_useTypeTextField.addActionListener(this);
            mainPanel.add((Component)this.m_useTypeTextField, "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    protected JPanel createButtonPanel() {
        JPanel mainPanel = null;
        GridBagConstraints gbConst = new GridBagConstraints();
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new GridBagLayout());
            gbConst.fill = 2;
            gbConst.gridwidth = 2;
            gbConst.gridheight = 1;
            gbConst.insets = new Insets(10, 10, 10, 10);
            mainPanel.add((Component)this.m_okButton, gbConst);
            mainPanel.add((Component)this.m_cancelButton, gbConst);
            mainPanel.add((Component)this.m_helpButton, gbConst);
            this.m_okButton.addActionListener(this);
            this.m_cancelButton.addActionListener(this);
            this.m_helpButton.addActionListener(this);
            this.getRootPane().setDefaultButton(this.m_okButton);
            this.setOKButtonState();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    public int getReturnStatus() {
        return this.m_returnStatus;
    }

    public Address getAddress() {
        return this.m_address;
    }

    public boolean hasChanged() {
        return this.m_bChanged;
    }

    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();
        if (obj == this.m_cancelButton) {
            this.m_returnStatus = 1;
            this.setVisible(false);
        } else if (obj == this.m_okButton) {
            String addressText = this.m_addressTextArea.getText();
            this.m_returnStatus = 0;
            if (addressText == null || addressText.length() == 0) {
                VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.s_noAddressDesc, VWResource.s_errorMessage, 1);
            } else {
                Vector<AddressLine> addressVector = new Vector<AddressLine>();
                StringTokenizer st = new StringTokenizer(addressText, "\n");
                while (st.hasMoreTokens()) {
                    addressVector.addElement(new AddressLine(st.nextToken().trim()));
                }
                this.m_address.setAddressLineVector(addressVector);
            }
            this.m_address.setUseType(this.m_useTypeTextField.getText());
            this.setVisible(false);
        } else if (obj == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc089.htm");
        } else if (obj == this.m_addressTextArea) {
            JButton defaultButton = this.getRootPane().getDefaultButton();
            defaultButton.doClick();
        } else if (obj == this.m_useTypeTextField) {
            this.m_bChanged = true;
        }
    }

    public void insertUpdate(DocumentEvent event) {
        this.setOKButtonState();
        this.m_bChanged = true;
    }

    public void removeUpdate(DocumentEvent event) {
        this.setOKButtonState();
        this.m_bChanged = true;
    }

    public void changedUpdate(DocumentEvent event) {
        this.m_bChanged = true;
    }

    private void setOKButtonState() {
        if (this.m_okButton == null) {
            return;
        }
        boolean bEnable = true;
        String tempString = null;
        if (this.m_addressTextArea != null) {
            tempString = this.m_addressTextArea.getText();
            if (tempString == null || VWStringUtils.compare(tempString, "") == 0) {
                bEnable = false;
            }
        } else {
            bEnable = false;
        }
        if (this.m_okButton.isEnabled() != bEnable) {
            this.m_okButton.setEnabled(bEnable);
        }
    }
}

